### Plugin GUI Element Creation

**Menus**

When a menu is about to be displayed to the user (i.e., when the user clicks on a menu entry that creates a menu window to be displayed), the menu is first recursively cleared of all current elements.  After everything has been deleted from the menu, the menu is repopulated with the TKE core menu elements (if there are any).  Once these elements have been added to the menu, the plugin framework searches for any menu plugin action types in the selected plugin list.  When it finds a plugin action type that needs to be added to this menu, the element is added to the menu, creating any cascading menus that are needed to store the menu element (menus can contain a submenu hierarchy so that menu items can be intelligently grouped).  Once all of the missing cascading menus have been created (if needed), the menu action command is added to the last menu and it's "-command" option is setup to call the plugin's "do" procedure.  The "do" procedure for a plugin action type performs the main action of the plugin action type (which can basically be anything).  Once the command has been added to the window, the current plugin’s associated "handle\_state" procedure is called.  The purpose of the "handle\_state" procedure is to determine whether the menu item should be enabled (by returning a value of 1) or disabled (by returning a value of 0).

This process is repeated for each menu plugin action type.  Once all of the menu items have been added to the menu window, the window is displayed to the user.  If the user selects a menu item that corresponds to a plugin action, the "do" procedure for that action is invoked, allowing the plugin to do something meaningful.  If the menu item is associated with a table GUI element, the Tk reference to the table is given to the "do" procedure along with the row within the table that the user right-clicked in.  If the menu item is associated with a text GUI element, the Tk reference to the text widget is given to the "do" procedure.

**Text Bindings**

When a new file is opened in the editor, the editor UI is created and TKE core bindings are added to the text widget that contains the file text.  After TKE core bindings have been applied, the plugin framework is invoked to find any text binding actions used within plugins.  If a plugin has text bindings to add, the plugin framework creates a binding tag that is unique for the plugin and inserts the new tag into the tag binding list for the text widget in one of two places (depending on what has been specified in the action registration).  If the action specifies the “pretext” location, the binding is added prior to any TKE core bindtags.  It is important to note that any changes to the text widget will not be visible to the commands that are bound at this point.  If the action specifies the “posttext” location, the binding is added immediately after the text bind command is executed.  Any commands run at this point will be able to see the changes to the text widget (if any exist).

Take a look at the text\_binding example plugin in the plugin installation directory for an example of how text bindings can be used.

**Tk Windows**

The creation and manipulation of Tk windows (widgets) by a plugin is actually handled within the master.  When the plugin interpreter needs to create a Tk widget, the widget is specified just as though the widget was being created in the plugin interpreter.  For example, to create a top-level window with a single button in the window, the plugin would perform the following:

```Tcl
toplevel .mywin
ttk::button .mywin.b -text “Click Me” -command { foo::click_me }
pack .mywin.b
```

In this example, a single button will be created in a new toplevel window with the text “Click Me”.  If the button is clicked, the procedure foo\::click\_me (which would exist in the plugin interpreter) would be executed.  Since all Tk commands are run in the master, a restricted set of the Tk command set is provided.  However, all widgets will be themed and configured to match the look and feel of the rest of the Tk window (and they will change to match the UI theme if the user changes the UI theme).  The following table lists the available Tk commands and any usage differences between the plugin Tk command set and the standard Tk command set.

| Command | Difference Description |
| - | - |
| canvas<br>listbox<br>menu<br>text<br>toplevel<br>ttk::button<br>ttk::checkbutton<br>ttk::combobox<br>ttk::entry<br>ttk::frame<br>ttk::label<br>ttk::labelframe<br>ttk::menubutton<br>ttk::notebook<br>ttk::panedwindow<br>ttk::progressbar<br>ttk::radiobutton<br>ttk::scale<br>ttk::scrollbar<br>ttk::separator<br>ttk::spinbox<br>ttk::treeview<br>ctext<br>tokenentry::tokenentry<br>wmarkentry::wmarkentry | None.  All commands are executed in the plugin interpreter and any variables referenced are variables which exist in the plugin interpreter.  Any Tk widgets that are created on behalf of the plugin are destroyable by that plugin.  Any other widgets that are passed to the plugin may not be destroyed by the plugin. |
| clipboard<br>event<br>focus<br>font<br>grid<br>pack<br>place<br>tk\_messageBox<br>tk_chooseColor<br>fontchooser<br>tk_getOpenFile<br>tk_getSaveFile<br>tk_chooseDirectory<br>tkwait | None.  All commands are executed in the plugin interpreter and any variables referenced are variables which exist in the plugin interpreter.  Any Tk widgets that are created on behalf of the plugin are destroyable by that plugin.  Any other widgets that are passed to the plugin may not be destroyed by the plugin. |
| destroy | Any Tk widgets created by the plugin are destroyed; however, any widgets not created by the plugin are not destroyable.  An error will be returned instead. |
| bind | All commands specified are executed in the plugin interpreter. |
| winfo atom<br>winfo atomname<br>winfo cells<br>winfo children<br>winfo class<br>winfo colormapfull<br>winfo depth<br>winfo exists<br>winfo fpixels<br>winfo geometry<br>winfo height<br>winfo id<br>winfo ismapped<br>winfo manager<br>winfo name<br>winfo pixels<br>winfo pointerx<br>winfo pointerxy<br>winfo pointery<br>winfo reqheight<br>winfo reqwidth<br>winfo rgb<br>winfo rootx<br>winfo rooty<br>winfo screen<br>winfo screencells<br>winfo screendepth<br>winfo screenheight<br>winfo screenmmheight<br>winfo screenmmwidth<br>winfo screenvisual<br>winfo screenwidth<br>winfo viewable<br>winfo visual<br>winfo visualsavailable<br>winfo vrootheight<br>winfo vrootwidth<br>winfo vrootx<br>winfo vrooty<br>winfo width<br>winfo x<br>winfo y | Only Tk widgets created by the plugin may be interrogated via the winfo command. |
| winfo containing<br>winfo parent<br>winfo pathname<br>winfo toplevel | If the result from executing this command is the name of a window which was created by the plugin, a valid result will be returned; otherwise, an error will be returned. |
| wm | If the passed window was created by the plugin, the wm command may be executed; otherwise, an error will be returned. |
| image | If the -file or -maskfile options are specified, the image command will allow these files to be read if the file exists in a directory/subdirectory of one of the trusted directories.  If a file is specified with options outside of an trusted directory, an error will be returned.  Only images created by the plugin will be deletable by the plugin.  If the plugin is uninstalled, the images created by the plugin will be automatically destroyed. |
| tk::TextSetCursor<br>tk::TextUpDownLine<br>tk::SetFocusGrab<br>tk::RestoreFocusGrab<br>tk::PlaceWindow | These methods are low-level Tk methods that are exposed for plugin use. These procedures are undocumented and, therefore, may be deprecated within Tcl/Tk at any time with or without notice. However, the latest version of Tk at the time of this writing (8.6.6) still supports this feature. |
